using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace Remove_and_Insert_via_Method {
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form {
        private SqlConnection cn;
        private SqlCommand cmd;
        private SqlDataAdapter da;
        private DataSet ds; 
        private DataRow rowFound;
        private int i;

        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.Button btnSearch;
        internal System.Windows.Forms.TextBox txtSearchFor;
        internal System.Windows.Forms.Button btnRemoveRow;
        internal System.Windows.Forms.DataGrid DataGrid1;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1() {
            try{

                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                cn = new SqlConnection("server=.;database=biblio;uid=admin;pwd=pw");
                cmd = new SqlCommand("Select ISBN, Title, Price, Year_Published from Titles Order by ISBN", cn);
                da= new SqlDataAdapter(cmd);
                ds= new DataSet();

                da.Fill(ds);
                DataGrid1.PreferredColumnWidth = 200;
                DataGrid1.DataSource = ds.Tables[0];

            }
            catch(Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing ) {
            if( disposing ) {
                if (components != null) {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent() {
            this.Label1 = new System.Windows.Forms.Label();
            this.btnSearch = new System.Windows.Forms.Button();
            this.txtSearchFor = new System.Windows.Forms.TextBox();
            this.btnRemoveRow = new System.Windows.Forms.Button();
            this.DataGrid1 = new System.Windows.Forms.DataGrid();
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
            this.SuspendLayout();
            // 
            // Label1
            // 
            this.Label1.Location = new System.Drawing.Point(200, 352);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(120, 16);
            this.Label1.TabIndex = 9;
            this.Label1.Text = "ISBN";
            // 
            // btnSearch
            // 
            this.btnSearch.Location = new System.Drawing.Point(72, 376);
            this.btnSearch.Name = "btnSearch";
            this.btnSearch.Size = new System.Drawing.Size(96, 24);
            this.btnSearch.TabIndex = 8;
            this.btnSearch.Text = "Search for ...";
            this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
            // 
            // txtSearchFor
            // 
            this.txtSearchFor.Location = new System.Drawing.Point(192, 376);
            this.txtSearchFor.Name = "txtSearchFor";
            this.txtSearchFor.Size = new System.Drawing.Size(160, 20);
            this.txtSearchFor.TabIndex = 7;
            this.txtSearchFor.Text = "0-0234299-0-9";
            // 
            // btnRemoveRow
            // 
            this.btnRemoveRow.Location = new System.Drawing.Point(464, 368);
            this.btnRemoveRow.Name = "btnRemoveRow";
            this.btnRemoveRow.Size = new System.Drawing.Size(112, 24);
            this.btnRemoveRow.TabIndex = 6;
            this.btnRemoveRow.Text = "Remove This Row";
            this.btnRemoveRow.Click += new System.EventHandler(this.btnRemoveRow_Click);
            // 
            // DataGrid1
            // 
            this.DataGrid1.DataMember = "";
            this.DataGrid1.Dock = System.Windows.Forms.DockStyle.Top;
            this.DataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
            this.DataGrid1.Name = "DataGrid1";
            this.DataGrid1.Size = new System.Drawing.Size(696, 344);
            this.DataGrid1.TabIndex = 5;
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(696, 438);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.Label1,
                                                                          this.btnSearch,
                                                                          this.txtSearchFor,
                                                                          this.btnRemoveRow,
                                                                          this.DataGrid1});
            this.Name = "Form1";
            this.Text = "Form1";
            ((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
            this.ResumeLayout(false);

        }
#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() {
            Application.Run(new Form1());
        }

        private void btnSearch_Click(object sender, System.EventArgs e) {
            try {
                DataTable tb = ds.Tables[0];
                int intRow;
                DataColumn[] dcolPk = new DataColumn[1];
                dcolPk[0] = tb.Columns["ISBN"];
                tb.PrimaryKey = dcolPk;
                tb.DefaultView.Sort = "ISBN";
                if (tb.Rows.Contains(txtSearchFor.Text)) {
                    // at least one row matches primary key
                    rowFound = tb.Rows.Find(txtSearchFor.Text);
                    intRow = ds.Tables[0].DefaultView.Find(txtSearchFor.Text);
                    if ((rowFound == null) | (intRow == -1)) {
                        MessageBox.Show("Could not find row ");
                    }
                    else {
                        DataGrid1.CurrentRowIndex = intRow;
                    }
                }
                else {
                    MessageBox.Show("No row found that matches " + txtSearchFor.Text);
                }
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }

        private void btnRemoveRow_Click(object sender, System.EventArgs e) {
            try {
                ds.Tables[0].Rows.Remove(rowFound);
            }
            catch(Exception ex) {
                Debug.WriteLine(ex.ToString());
                MessageBox.Show(ex.ToString());
            }
        }
    }
}